<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Player extends Model 
{

    protected $table = 'player';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function games()
    {
        return $this->belongsToMany('App\Models\Game');
    }

    public function user()
    {
        return $this->hasOne('App\Models\User');
    }

    public function group()
    {
        return $this->belongsTo('App\Models\Group');
    }

}